#include <iostream>
#include <map>
#include <fstream>
#include <list>
#include <queue>
#include<conio.h>
#define min(a, b) ((a) < (b) ? (a) : (b)) 

using namespace std;
struct positionCode
{
        unsigned int code;
	   positionCode *next;		
};

struct node
{	
  	int event;	
  	int occur;	
  	int pcLength;
	positionCode *pcCode;
	int CountSon;
  	node *nextLink;	
  	node *lSon;	
  	node *rSibling;	
  	node *parent;	
};

struct linkheader
{			
        int event;	
        int occur;	
        node *link;	
        node *lastLink;
};

typedef multimap<int, int, less<int> > sequence;  
		

list<linkheader> lnkhdr; 
node *root;		
int frequency;	
int seqNumber;	
float minSupp;	
void BuildTree(char*);
			
positionCode* makeCode(int, positionCode*, bool);	
int checkPosition(positionCode*, int, positionCode*, int);	
void MiningProcess(list<node*>, queue<int>, int );			
		
int main()
{
	list<node*> newRootSet;
	queue<int> beginPattern;

	cout << "please enter the minimum support:";  
			
	cin >> minSupp;
			
			cout<<"enter transaction ";
			cin>>seqNumber;
			

        clock_t start, end;
         double cpu_time_used;


	start = clock();

		

	BuildTree("sequentialdatabase .txt"); 			
	newRootSet.push_back(root);

			cout<<"\n\nBegin the mining process"<<endl;
	
	MiningProcess(newRootSet, beginPattern, seqNumber);

	
	end = clock();
       cpu_time_used = ((double) (end - start)) / CLOCKS_PER_SEC;

	
	 cout<<"The CPU time used is : "<< cpu_time_used << endl;
	cout<<"\n\nEnd the program"<<endl;
getch();
	return 0;
}

void MiningProcess(list<node*> rootSet, queue<int> basePattern, int Count)
{
		list<linkheader>::iterator pnt;
        for( pnt = lnkhdr.begin(); pnt != lnkhdr.end(); pnt++)
        {
                list<node*> newRootSet;
                node * SavePoint = NULL;
                bool DescSave = false;
                bool RootUsed = false;
                int totalSon = 0;
                int count = 0;
                int emptySon = 0;
                int RootCount = Count;

                node * linkBrow = pnt -> link;
                list<node*>::iterator rootBrow = rootSet.begin();

                while (linkBrow != NULL && rootBrow != rootSet.end() && RootCount >= frequency )
                {
                        int check = checkPosition(((*rootBrow)->lSon)->pcCode, (*rootBrow)->pcLength+1, linkBrow->pcCode, linkBrow->pcLength);
					
                        switch ( check ){
                        case 0:
                                if ( SavePoint != NULL )
                                {
                                        if ( SavePoint->lSon == NULL )
                                                DescSave = false;
                                        else
                                                if (checkPosition( (SavePoint->lSon)->pcCode, SavePoint->pcLength+1, linkBrow->pcCode, linkBrow->pcLength)== 0)
                                                        DescSave = true;
                                                else DescSave = false;
                                }

                                if ( !DescSave)
                                {
                                        count = count + linkBrow->occur;
                                        totalSon = totalSon + linkBrow->CountSon;
                                        RootUsed = true;
                                        SavePoint = linkBrow;
                                        if (linkBrow->lSon != NULL)
                                                newRootSet.push_back(linkBrow);
                                        else
                                                emptySon = emptySon + linkBrow->occur;
                                }
                                linkBrow = linkBrow->nextLink;
                                break;
                        case 1:
                                rootBrow++;
                                RootUsed = false;
                                break;
                        case 2:
                                linkBrow = linkBrow->nextLink;
                                break;
                        case 3:
                                linkBrow = linkBrow->nextLink;
                                break;
                        }
                }

                if ( count >= frequency)
                {
                        queue<int> tempPattern = basePattern;

                        tempPattern.push(pnt->event);
                        queue<int> otherPattern = tempPattern;
                        while(!tempPattern.empty())
                        {
                               
                                tempPattern.pop();
                        }
                        

                        if ( totalSon >= frequency)
                                MiningProcess(newRootSet, otherPattern, count-emptySon);
                }
        }
        return;
}



void BuildTree(char *sourceFile)
{
	sequence seq, duplicate;
	ifstream ins ( sourceFile, ios::in);

	if ( !ins) {
		cerr << " File could not be opened\n";
		exit(1);
	}

	sequence::iterator point, eflag;
	int event, cid, number;
	for(int i=0;i<seqNumber;i++)
	{
                ins >> number;
         duplicate.clear();

		for(int i=0; i< number; i++)
        {
			ins >> event;

            if ( duplicate.find(event) == duplicate.end())
            {
        		duplicate.insert(sequence::value_type(event, 1));

	        	point = seq.find(event);
		        eflag = seq.end();
				if ( point != eflag)
	        			point ->second ++;
        		else
	        			seq.insert( sequence::value_type(event,1));

		    }
        }
	}


        frequency = (int)(minSupp* seqNumber);
        cout<<"min:"<<minSupp<<"  "<<"total tran:"<<seqNumber<<"   "<<"Support:"<<frequency<<"\n";

        sequence::iterator i, bi;

		i = seq.begin();
        while( i!=seq.end())
        {
            bi = i;
			if( i != seq.end())
			{
                 bi++;
			}

            if (i->second < frequency)
            {
                seq.erase(i);
                i=bi;
            }
			else
				i++;
        }
   
        node *Tranversal, *newNode, *Parent;

        root = new node;
        root->event = -1;
        root->occur = seqNumber;
        root->CountSon = 0;
        root->pcLength = 0;
        root->parent = NULL;
        root->lSon = NULL;
        root->rSibling = NULL;
        root->nextLink = NULL;
        root->pcLength = 0;

        ifstream inFile ( sourceFile, ios::in);

		if ( !inFile) {
			cerr << " File could not be opened\n";
			exit(1);
		}

	for(int i=0;i<seqNumber;i++)
		{
		
			inFile >> number;

			Tranversal = root;

			for(int i=0; i< number; i++)
			{
				inFile >> event;

				if(seq.find(event) != seq.end())
				{
                        Parent = Tranversal;

                        if( Tranversal->lSon == NULL)					
                        {
                                newNode = new node;
                                newNode->event = event;
                                newNode->occur = 1;
                                newNode->lSon = NULL;
                                newNode->rSibling = NULL;
								newNode->nextLink = NULL;
                                newNode->CountSon = 0;
                                Parent->CountSon ++;
                                newNode->parent = Parent;
                                newNode->pcLength = Tranversal->pcLength + 1;
                                newNode->pcCode = makeCode(Tranversal->pcLength,Tranversal->pcCode,true);
                                Tranversal->lSon = newNode;
                                Tranversal = newNode;
                        }
                        else
                        {						
                                Tranversal = Tranversal->lSon;
                                if ( Tranversal->event == event)								
                                {
                                        (Tranversal->parent)->CountSon++;
                                        Tranversal->occur++;
                                }
                                else
                                {
                                        bool find= false;
                                        while(Tranversal->rSibling != NULL && !find )										
                                        {
                                                Tranversal = Tranversal->rSibling;
                                                if ( Tranversal->event == event)
                                                {
                                                        Tranversal->occur ++;
                                                        (Tranversal->parent)->CountSon++;
                                                        find = true;
                                                }
                                        }
                                        if (!find)									
                                        {
                                                newNode = new node;
                                                newNode->event = event;
                                                newNode->occur = 1;
                                                newNode->lSon = NULL;
                                                newNode->rSibling = NULL;
												newNode->nextLink = NULL;
												newNode->CountSon = 0;
                                                Parent->CountSon ++;
                                                newNode->parent = Parent;
                                                newNode->pcLength = Tranversal->pcLength + 1;
                                                newNode->pcCode = makeCode(Tranversal->pcLength,Tranversal->pcCode, false);
                                                Tranversal->rSibling = newNode;
                                                Tranversal = newNode;
                                        }
                                }
                        }
				}
			}
		}

		
        linkheader *newLinkHeader;
        for (  i = seq.begin(); i!=seq.end(); i++)			
        {
                newLinkHeader = new linkheader;
                newLinkHeader->link = NULL;
                newLinkHeader->lastLink = NULL;
                newLinkHeader->event= i->first;
                newLinkHeader->occur= i->second;
                lnkhdr.push_back(*newLinkHeader);
                free(newLinkHeader);
        }
        
}


positionCode * makeCode(int length, positionCode *pCode, bool addOne)
{
		positionCode *start, *browser, *newPC;
        int leftCount = length % 32;
        int linkCount = (int)(length / 32);

        if ( linkCount == 0 )
        {
                start = new positionCode;
                start->next = NULL;
                if (length == 0)
                        start->code = 1 << 31;
                else
                        if (addOne)
                                start->code = pCode->code | (1<<(31-leftCount));
                        else
                                start->code = pCode->code ;
                return start;
        }
        else
        {
                newPC = new positionCode;
                newPC->code = pCode->code;
                pCode = pCode ->next;
                start = newPC;
                browser = start;

                for(int i = 1; i < linkCount; i++)
                {
                        newPC = new positionCode;
                        newPC->code = pCode->code;
                        browser-> next = newPC;
                        browser = newPC;
                        pCode = pCode->next;
                }

                if (leftCount == 0)
                {
                        newPC = new positionCode;
                        if (addOne)
                                newPC->code = 1 << 31;
                        else
                                newPC->code = 0 << 31;
                        newPC->next = NULL;
                        browser->next = newPC;
                }
                else
                {
                        newPC = new positionCode;

                        if (addOne)
                                newPC->code = pCode->code | (1<<(31-leftCount));
                        else
                                newPC->code = pCode->code;

                        newPC ->next = NULL;
                        browser->next = newPC;
                }
        }

        return start;
}


int checkPosition(positionCode *FirstNode, int aLength, positionCode *SecondNode, int dLength)
{

        if (aLength == 1 )
                return 0;	
			
        int length = min(aLength,dLength);  
        int linkCount = (int)(length / 32);
        int leftCount = length % 32;

        for( int i = 0; i < linkCount; i++)
                if ( FirstNode->code > SecondNode->code)
                        return 1;
                else
                        if ( FirstNode->code < SecondNode->code)
                                return 2;
                        else
                        {
                                FirstNode = FirstNode->next;
                                SecondNode = SecondNode->next;
                        };


        unsigned int aCode, dCode;
        if ( aLength <= dLength )
        {
                if (leftCount == 0)
                        return 0;

                aCode = FirstNode -> code >> ( 32 - leftCount );
                dCode = SecondNode -> code >> ( 32 - leftCount );
                if (aCode == dCode )
                        return 0;
                else
                        if (aCode < dCode)
                                return 2;
                        else return 1;
        }
        else
        {
                if (leftCount == 0)
                        dCode = 1;
                else
                        dCode = ( SecondNode -> code >> ( 31 - leftCount )) | 1 ;
                aCode = FirstNode -> code >> ( 31 - leftCount );


                if ( aCode == dCode )
                        return 3;
                else
                        if (aCode < dCode)
                                return 2;
                        else return 1;

        }

}

